/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import java.util.StringTokenizer;
import oracle.cluster.verification.StorageSize;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.FSInfo;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageInfo;

public class NFSInfo
extends StorageInfo
implements StorageConstants {
    private String m_server;
    private String m_serverIP = null;
    private String m_pathOnServer;
    private String m_mountPoint;
    private String m_mountOpts = null;
    private boolean m_isReadOnly = false;
    private boolean m_isNoac = false;
    private FSInfo m_fsInfo;

    public NFSInfo(String node, String mountPoint, String server, String pathOnServer, String mountOpts) {
        this(node, mountPoint, server, pathOnServer, mountOpts, null);
    }

    public NFSInfo(String node, String mountPoint, String server, String pathOnServer, String mountOpts, FSInfo fsInfo) {
        super(mountPoint, node, 2);
        this.m_mountPoint = mountPoint;
        this.m_server = server;
        this.m_pathOnServer = pathOnServer;
        this.m_mountOpts = mountOpts;
        this.m_isReadOnly = NFSInfo.isMountReadOnly(this.m_mountOpts);
        this.m_isNoac = NFSInfo.isMountNoac(this.m_mountOpts);
        this.m_fsInfo = fsInfo;
    }

    public FSInfo getFSInfo() {
        return this.m_fsInfo;
    }

    public void setFSInfo(FSInfo fsInfo) {
        this.m_fsInfo = fsInfo;
    }

    @Override
    public StorageSize getFree() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("NFS Free space on " + this.m_fsInfo.getPath() + " = " + this.m_fsInfo.getFree()));
        }
        return this.m_fsInfo.getFree();
    }

    @Override
    public StorageSize getSize() {
        return this.m_fsInfo.getSize();
    }

    @Override
    public String getSignature() {
        String signature = null == this.m_serverIP ? this.m_server + ":" + this.m_pathOnServer : this.m_serverIP + ":" + this.m_pathOnServer;
        return signature;
    }

    @Override
    public String toString() {
        return this.m_node + ":" + this.m_mountPoint + " | server: " + this.m_server + ":" + this.m_pathOnServer + "<" + this.m_mountOpts + "> | FSInfo: " + this.m_fsInfo;
    }

    protected String getMountPoint() {
        return this.m_mountPoint;
    }

    protected String getServer() {
        return this.m_server;
    }

    protected String getPathOnServer() {
        return this.m_pathOnServer;
    }

    protected boolean isReadOnly() {
        return this.m_isReadOnly;
    }

    protected boolean isNoac() {
        return this.m_isNoac;
    }

    protected void setServerIP(String ip) {
        this.m_serverIP = ip;
    }

    protected String getServerIP() {
        return this.m_serverIP;
    }

    protected String getMountOpts() {
        return this.m_mountOpts;
    }

    private static boolean isMountNoac(String mntOpts) {
        boolean isNoac = -1 != mntOpts.indexOf("noac");
        return isNoac;
    }

    private static boolean isMountReadOnly(String mntOpts) {
        boolean isReadOnly = false;
        boolean found = false;
        StringTokenizer stComma = new StringTokenizer(mntOpts, ",");
        while (stComma.hasMoreTokens() && !found) {
            String currOpt = stComma.nextToken();
            if (currOpt.equalsIgnoreCase("ro")) {
                isReadOnly = true;
                found = true;
                continue;
            }
            if (!currOpt.equalsIgnoreCase("rw")) continue;
            isReadOnly = false;
            found = true;
        }
        return isReadOnly;
    }
}

